-- MOLOCH

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================

fireDelay = 2
moveTimer = 0
charge = 0

STATE_CHARGE = 1000
STATE_DELAY = 1001
inited = false

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(
	me,
	"",								-- texture
	6,								-- health
	2,								-- manaballamount
	2,								-- exp
	1,								-- money
	48,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000							-- updateCull -1: disabled, default: 4000
	)
	entity_scale(me, 0.75, 0.75)
	entity_setDropChance(me, 25)
	entity_clampToSurface(me)
	entity_setDeathParticleEffect(me, "PurpleExplode")
	entity_initSkeletal(me, "Moloch")
	charge = entity_getBoneByName(me, "Charge")
	bone_alpha(charge, 0)
	entity_animate(me, "idle")
	inited = true
	
	entity_setEatType(me, EAT_FILE, "HotEnergy")
end

function update(me, dt)
	entity_handleShotCollisions(me)
	entity_touchAvatarDamage(me, entity_getCollideRadius(me), 1, 0.1)

	if entity_isState(me, STATE_IDLE) then
		entity_moveAlongSurface(me, dt, 140, 6, 10)
		entity_rotateToSurfaceNormal(me, 0.1)

		-- entity_rotateToSurfaceNormal(0.1)
		moveTimer = moveTimer + dt
		if moveTimer > 4 then
			entity_switchSurfaceDirection(me)
			moveTimer = 0
		end	
		if not(entity_hasTarget(me)) then
			entity_findTarget(me, 1200)
		else
			if fireDelay > 0 then
				fireDelay = fireDelay - dt
				if fireDelay < 0 then
					fireDelay = 3
					entity_setState(me, STATE_CHARGE)
				end
			end
		end
	end
	if entity_isState(me, STATE_CHARGE) or entity_isState(me, STATE_DELAY) then
		entity_moveAlongSurface(me, dt, 60, 6, 10)
		entity_rotateToSurfaceNormal(me, 0.1)
	end
	if isObstructed(entity_x(me), entity_y(me)) then
		entity_adjustPositionBySurfaceNormal(me, 1)
	end
end

function enterState(me)
	if entity_getState(me)==STATE_IDLE then
		if inited then
			bone_setSegs(entity_getBoneByName(me, "Body"), 2, 16, 0.3, 0.3, -0.028, 0, 6, 1)
		end
	elseif entity_isState(me, STATE_CHARGE) then
		t = 3
		entity_setStateTime(me, t)
		bone_scale(charge)
		bone_scale(charge, 1.5, 1.5, t)
		--[[
		bone_offset(charge, -5)
		bone_offset(charge, 5, 0, 0.5, -1)
		]]--
		bone_alpha(charge, 1, 0.5)
		bone_setSegs(entity_getBoneByName(me, "Body"), 2, 16, 0.3, 0.3, -0.058, 0, 12, 1)
	elseif entity_isState(me, STATE_DELAY) then
		entity_setStateTime(me, 1)
	end
end

function exitState(me)
	if entity_isState(me, STATE_CHARGE) then
		sx,sy= bone_getScale(charge)
		if sx > 1.2 then
			bone_alpha(charge, 0, 0.2)
			--entity_doGlint(me, "Particles/PurpleFlare")
			--s = entity_fireAtTarget(me, "", 1.5, 700, 500, 3, 64)
			--shot_setNice(s, "Shots/HotEnergy", "HeatTrail", "HeatHit")
			s = createShot("HotEnergy", me, entity_getTarget(me), bone_getWorldPosition(charge))
		end
		entity_setState(me, STATE_DELAY)
	elseif entity_isState(me, STATE_DELAY) then
		entity_setState(me, STATE_IDLE)
	end
end

function damage(me)
	return true
end

function hitSurface(me)
end
