dofile("scripts/entities/entityinclude.lua")

n = 0
beam = 0
timer = 0

delayTimeMin = 1
delayTimeMax = 0.25
delay = delayTimeMin
delayTime = delayTimeMin
delayTimeBit = 0.05

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_setTexture(me, "SunkenMom/MomEyes")
	entity_setAllDamageTargets(me, false)
	
	entity_alpha(me)
	entity_alpha(me, 1, 0.1)
	entity_setState(me, STATE_IDLE)
	entity_scale(me, 1, 0.1)
	entity_scale(me, 1, 1, 0.4, 0, 1)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	if timer == -1 then return end

	sx,sy = entity_getScale(me)
	if sy == 1 then
		delay = delay - dt
		if delay < 0 then
			delay = delayTime
			
			s = createShot("MomVision", me, n, entity_x(me), entity_y(me)+16)
			shot_setAimVector(s, randVector(1))
			
			if delayTime > delayTimeMax then
				delayTime = delayTime - delayTimeBit
			end
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_DONE) then
		entity_scale(me, 1, 0.1, 0.2)
		entity_delete(me, 0.2)		
		timer = -1
		if beam ~= 0 then
			beam_delete(beam)
		end
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

