-- ================================================================================================
-- M O N E Y E
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")


spawnTime = 5
spawnTimer = 1

bounces = 0

-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================
 
-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(me, 
	"MoneyeBreeder",					-- texture
	9,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	28,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	3000							-- updateCull -1: disabled, default: 4000
	)
	entity_setSegs(me, 2, 32, 0.1, 0.1, -0.018, 0, 2.5, 1)
	entity_setDeathParticleEffect(me, "TinyGreenExplode")
	entity_setEatType(me, EAT_FILE, "MoneyeBreeder")
end

function update(me, dt)
	if entity_isState(me, STATE_GROW) then
		entity_addVel(me, 0, 1000*dt)
		entity_updateMovement(me, dt)
	else
		
		if entity_isEntityInRange(me, getNaija(), 900) then
			spawnTimer = spawnTimer - dt
			if spawnTimer < 0 then
				--debugLog("Spawning")
				out = 40
				nx, ny = entity_getNormal(me)
				nx = nx * out
				ny = ny * out
				spawnTimer = spawnTime
				moneye = createEntity("Moneye", "", entity_x(me)+nx, entity_y(me)+ny)
				spawnParticleEffect("MoneyeBirth", entity_x(me)+nx, entity_y(me)+ny)
				entity_alpha(moneye, 0)
				entity_alpha(moneye, 1, 0.5)
			end
		else
			spawnTimer = spawnTimer - dt*0.5
		end
	end
	entity_handleShotCollisions(me)
end

function enterState(me)
	if entity_getState(me)==STATE_IDLE then
	elseif entity_isState(me, STATE_GROW) then
		entity_setMaxSpeed(me, 800)		
	end
end

function exitState(me)
end

function hitSurface(me)
	if entity_isState(me, STATE_GROW) then
		
		entity_rotateToSurfaceNormal(me)
		bounces = bounces + 1
		if bounces > 3 then
			entity_setState(me, STATE_IDLE)
		end
	end
end

function dieNormal(me)
	if chance(100) then
		spawnIngredient("SmallEgg", entity_x(me), entity_y(me))
	end
end

