-- N A U T I L U S

dofile("scripts/entities/entityinclude.lua")
-- entity specific
STATE_ATTACKPREP		= 1000
STATE_ATTACK			= 1001

lungeDelay = 0					-- prevents the nautilus from lunging over and over
dodgeTimer = 0
-- initializes the entity
function init(me)
	setupBasicEntity(
	me,
	"Mutilus/Mutilus",						-- texture
	6,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	32,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	128,								-- sprite width
	128,								-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	-1,								-- updateCull -1: disabled, default: 4000
	1
	)

	entity_setDeathParticleEffect(me, "TinyBlueExplode")
	
	entity_setDropChance(me, 10, 1)
	
	entity_rotate(me, 360, 1, LOOP_INF)		-- make the nautilus spin 360 degrees endlessly over 1 second
	lungeDelay = 1.0						-- prevent the nautilus from attacking right away
	
	entity_setEatType(me, EAT_FILE, "SmallFood")
	
	--entity_initSkeletal(me, "Mutilus")	
	--entity_scale(me, 1.2, 1.2)
end

-- the entity's main update function
function update(me, dt)	
	-- in any state: if we have a target and we're close enough, hurt the target and move back	
	-- in idle state only
	if entity_getState(me)==STATE_IDLE then
		-- count down the lungeDelay timer to 0
		if lungeDelay > 0 then lungeDelay = lungeDelay - dt if lungeDelay < 0 then lungeDelay = 0 end end
		
		dodgeTimer = dodgeTimer + dt
		if dodgeTimer > 3 then
			dodgeTimer = 0
		end
		-- if we don't have a target, find one
		if not entity_hasTarget(me) then
			entity_findTarget(me, 1000)
		else
			if entity_isTargetInRange(me, 1600) then
				if entity_isTargetInRange(me, 200) then
					entity_moveTowardsTarget(me, dt, -500)		-- if we're too close, move away
				else					
					entity_moveTowardsTarget(me, dt, 1000)		-- move in if we're too far away
				end
			end
			
			-- 40% of the time when we're in range and not delaying, launch an attack
			if entity_isTargetInRange(me, 300) then
				if math.random(100) < 40 and lungeDelay == 0 then
					entity_setState(me, STATE_ATTACKPREP, 0.5)
				end
			end
			
			entity_doEntityAvoidance(me, dt, 128, 0.5)
			if dodgeTimer > 1.5 then
				entity_doSpellAvoidance(me, dt, 256, 1)
			end
			entity_doCollisionAvoidance(me, dt, 4, 0.1)
		end
	end
	entity_updateCurrents(me, dt)
	entity_updateMovement(me, dt)
	
	entity_handleShotCollisions(me)
	if entity_hasTarget(me) then
		if entity_touchAvatarDamage(me, 32, 1) then
			entity_moveTowardsTarget(me, dt, -10000)
		end
	end	
end

function enterState(me)
	if entity_getState(me)==STATE_IDLE then
		entity_setMaxSpeed(me, 600)
	elseif entity_getState(me)==STATE_ATTACKPREP then
		entity_sound(me, "Nautilus", 1200+math.random(100))
		entity_setMaxSpeed(me, 0)
		entity_doGlint(me, "Glint", BLEND_ADD)
	elseif entity_getState(me)==STATE_ATTACK then
		entity_enableMotionBlur(me)
		lungeDelay = 2.0
		entity_setMaxSpeed(me, 1200)
		entity_moveTowardsTarget(me, 1200, 1)
	end
end

function exitState(me)
	if entity_getState(me)==STATE_ATTACKPREP then
		entity_setState(me, STATE_ATTACK, 0.6)
	elseif entity_getState(me)==STATE_ATTACK then
		entity_disableMotionBlur(me)
		entity_setState(me, STATE_IDLE)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	if entity_getHealth(me)-dmg <= 0 then
		entity_sound(me, "Nautilus", 900 + math.random(100))
	else
		entity_sound(me, "Nautilus", 600 + math.random(100))
	end
	return true
end

function hitSurface(me)
end

function shiftWorlds(me, old, new)
end

function dieNormal(me)
end

