dofile("scripts/entities/entityinclude.lua")

STATE_RUNOFF			= 1000

n = 0

following = false
seen = false
spinning = false
followMia = false
fade = false

singTimer = 0

rot = 0

glowBody = 0
body = 0

runNode = 0

function normalSegs(me)
	bone_setSegs(entity_getBoneByIdx(me, 0), 2, 8, 0.7, 0.7, -0.02, 0, 6, 1)
end

function singSegs(me)
	bone_setSegs(entity_getBoneByIdx(me, 0), 2, 8, 0.7, 0.7, 0.02, 0, 6, 1)
end

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "Ompo")
	
	entity_setEntityLayer(me, 1)
	
	--entity_generateCollisionMask(me)	
	
	entity_scale(me, 0.7, 0.7)
	entity_setState(me, STATE_IDLE)
	
	
	normalSegs(me)
	
	
	glowBody = entity_getBoneByIdx(me,2)
	body = entity_getBoneByIdx(me, 0)
	
	entity_alpha(me, 1)
	bone_alpha(glowBody, 0)
	bone_setBlendType(glowBody, BLEND_ADD)
	
	entity_scale(me, 0.6, 0.6)
	
	
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
	
	runNode = getNode("OMPORUNOFF")
end

function update(me, dt)
	if entity_isState(me, STATE_IDLE) then
		if not following then
			entity_doCollisionAvoidance(me, dt, 2, 1)
			
			if following then 
				entity_moveTowardsTarget(me, dt, 800)
			else
				if entity_isEntityInRange(me, n, 512) then
					following = true
					entity_moveTowardsTarget(me, dt, 800)
					if isFlag(FLAG_OMPO, 2) then
						setFlag(FLAG_OMPO, 3)
						playSfx("Ompo")
						emote(EMOTE_NAIJALAUGH)
					end
				end
			end
			entity_flipToVel(me)
		
			entity_updateMovement(me, dt)
		else
			if followMia then
				tar = getEntity("13_MainArea")
				esetv(me, EV_LOOKAT, 0)
			else
				tar = entity_getNearestEntity(me, "13_MainArea", 1024)
				if tar == 0 then
					tar = n
				end
			end
			rot = rot + dt*0.2
			if avatar_isSinging() then
				rot = rot + dt*0.2
			end
			if rot > 1 then
				rot = rot - 1
			end
			dist = 100
			if tar == n then
				if avatar_isSinging() then
					dist = 150
				end
			else
				if fade then
					dist = 32
				else
					dist = 200
				end
			end
			t = 0
			x = 0
			y = 0
			if avatar_isRolling() then
				dist = 90
				spinDir = -avatar_getRollDirection()
				t = rot * 6.28
			else
				t = rot * 6.28
			end
			

			
			if not entity_isEntityInRange(me, tar, 2024) then
				entity_setPosition(me, entity_x(tar)+x, entity_y(tar)+y)
			end
			
			a = t
			x = x + math.sin(a)*dist
			y = y + math.cos(a)*dist
			
			if tar ~= n then
				if fade then
					entity_setPosition(me, entity_x(tar)+x, entity_y(tar)+y, 0.2)
				else
					entity_setPosition(me, entity_x(tar)+x, entity_y(tar)+y, 2)
				end
			elseif avatar_isSinging() then
				entity_setPosition(me, entity_x(tar)+x, entity_y(tar)+y, 0.2)
			else
				entity_setPosition(me, entity_x(tar)+x, entity_y(tar)+y, 0.6)
			end
			
			if tar == n then
				if not avatar_isSinging() then
					entity_flipToEntity(me, n)
				end
				
				if avatar_isSinging() then
					singTimer = singTimer + dt
					if singTimer > 4 then
						singTimer = 0 - math.random(4)
						if chance(50) then
							emote(EMOTE_NAIJAGIGGLE)
						end
						if chance(75) then
							playSfx("Ompo")
						end
						entity_rotate(me, 0)
						entity_rotate(me, -360, 1, 0, 0, 1)
					end
				else
					singTimer = singTimer - dt *2
					if singTimer < 0 then
						singTimer = 0
					end
				end
			else
				entity_flipToEntity(me, tar)
			end
		end

	end
	
	entity_handleShotCollisions(me)

	if isFlag(FLAG_OMPO, 0) and not seen and entity_isEntityInRange(me, n, 300) then
		playSfx("Ompo")
		emote(EMOTE_NAIJAGIGGLE)
		seen = true
	end
	
	if runNode ~= 0 and node_isEntityIn(runNode, me) then
		entity_setState(me, STATE_OFF)
	end
end

cut = false

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_OFF) then
		--- flee
		if cut then return end
		cut = true
		debugLog("setting off")
		following = false
		crack = getNode("CRACK")
		entity_idle(n)
		if entity_isfh(n) then entity_fh(n) end
		musicVolume(0.5, 1)
		watch(1)
		playSfx("Ompo")
		
		entity_offset(me, 0, -40, 0.2, 7, 1)
		watch(0.4)
		emote(EMOTE_NAIJAUGH)
		watch(0.6)
		watch(1)
		
		cam_toEntity(me)
		entity_setPosition(me, node_x(crack), node_y(crack, 3), 1, 0, 1)
		while entity_isInterpolating(me) do
			watch(FRAME_TIME)
		end
		
		entity_alpha(me, 0, 0.5)
		watch(0.5)
		cam_toEntity(n)
		watch(1)
		emote(EMOTE_NAIJASADSIGH)
		setFlag(FLAG_OMPO, 4)
		entity_delete(me)
		cut = false
		watch(1)
		musicVolume(1, 1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function msg(me, msg)
	if msg=="fmia" then
		followMia = true
		
		esetv(me, EV_LOOKAT, 0)
	elseif msg=="fade" then
		setFlag(FLAG_OMPO, 2)
		entity_delete(me, 2)
		fade = true
	end
end


function songNote(me, note)
	r,g,b = getNoteColor(note)
	--[[
	r = 0.5 + r*0.5
	g = 0.5 + g*0.5
	b = 0.5 + b*0.5
	entity_color(me, r, g, b, 0.1)
	]]--
	bone_color(glowBody, r, g, b, 0.2)
	bone_alpha(glowBody, 0.5)
	
	bone_scale(glowBody, 2, 2)
	bone_scale(glowBody, 5, 5, 0.5, -1, 1)
	--bone_scale(glowBody, 
	--[[
	if not spinning then
		spinning = true
		entity_rotate(me, 360+entity_getRotation(me), 1, -1)
	end
	]]--
	--bone_setBlendType(entity_getBoneByIdx(me,1), BLEND_ADD)
end

function songNoteDone(me, note)
	--bone_setColor(glowBody, 1, 1, 1, 1)
	bone_alpha(glowBody, 0, 4)
	--[[
	if spinning then
		spinning = false
		entity_rotate(me, 0, 1, 0, 0, 1)
	end
	]]--
end

function song(me, song)
end

function activate(me)
end

