-- ================================================================================================
-- R A S P B E R R Y
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================

fireDelay = 2
moveTimer = 0

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(
	me,
	"wallshooter",					-- texture
	4,								-- health
	2,								-- manaballamount
	2,								-- exp
	1,								-- money
	32,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000							-- updateCull -1: disabled, default: 4000
	)
	entity_setEatType(me, EAT_FILE, "Poison")
	entity_scale(me, 0.75, 0.75)
	entity_setDropChance(me, 25)
	entity_clampToSurface(me)
	entity_setDeathParticleEffect(me, "PurpleExplode")
	entity_setSegs(me, 2, 16, 0.6, 0.6, -0.028, 0, 6, 1)
	esetv(me, EV_WALLOUT, 12)
	esetvf(me, EV_CLAMPTRANSF, 0.2)
	
	entity_setColor(me, 0.5, 1, 0.5)
end

function update(me, dt)
	if eisv(me, EV_CLAMPING, 0) then
		-- dt, pixelsPerSecond, climbHeight, outfromwall
		-- out: 24
		entity_moveAlongSurface(me, dt, 80, 6)
		entity_rotateToSurfaceNormal(me, 0.1)
		-- entity_rotateToSurfaceNormal(0.1)
		moveTimer = moveTimer + dt
		if moveTimer > 10 then
			entity_switchSurfaceDirection(me)
			moveTimer = 0
		end
		if not(entity_hasTarget(me)) then
			entity_findTarget(me, 1200)
		else
			if fireDelay > 0 then
				fireDelay = fireDelay - dt
				if fireDelay < 0 then
					-- dmg, mxspd, homing, numsegs, out
					entity_doGlint(me, "Particles/PurpleFlare")
					--entity_fireAtTarget(me, "Purple", 1, 400, 200, 3, 64)
					nx, ny = entity_getNormal(me)
					nx, ny = vector_setLength(nx, ny, 48)
				
					s = createShot("Poison", me, entity_getTarget(me), entity_x(me)+nx, entity_y(me)+ny)
					
					--shot_setAimVector(s, )
					--[[
					
					shot_setAimVector(s, entity_getNormal(me))
					shot_setOut(s, 64)
					
					shot_setAimVector(s, 
					]]--
					
					fireDelay = 3
				end
			end
		end
	end
	
	entity_handleShotCollisions(me)
	entity_touchAvatarDamage(me, entity_getCollideRadius(me), 0.5, 500)	
end

function dieNormal(me)
end

--[[
function diedFrom(attacker, damageType)
	if damageType ~= DT_AVATAR_BITE then
		spawnIngredient("RubberyMeat", entity_getPosition(me))
	end
end
]]--

function enterState(me)
	if entity_getState(me)==STATE_IDLE then	
	end
end

function damage(me, attacker, bone, damageType, dmg)
	if damageType == DT_AVATAR_BITE or attacker == me then
		entity_changeHealth(me, -99)
	end
	return true
end

function exitState(me)
end

function hitSurface(me)
end
