-- ================================================================================================
-- M A U L
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- entity specific
STATE_FIRE				= 1000
STATE_PULLBACK			= 1001
fireDelay = 0

dir = 0
 
-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(
	me,
	"Fish-RockHead",				-- texture
	3,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	20,								-- collideRadius 
	STATE_IDLE,						-- initState
	90,							-- sprite width	
	90,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	-1							-- updateCull -1: disabled, default: 4000
	)
		
	entity_setDropChance(me, 50)
	
	entity_setMaxSpeedLerp(me, 0.5)
	entity_setMaxSpeedLerp(me, 1, 1, -1, 1)
	entity_setSegs(me, 8, 2, 0.1, 0.2, 0, -0.03, 8, 0)
	entity_setDeathParticleEffect(me, "TinyBlueExplode")
end

function update(me, dt)	
	entity_handleShotCollisions(me)
	entity_touchAvatarDamage(me, 20, 1, 1200)
	
	if dir==0 then
		entity_addVel(me, -1000, 0)
	else
		entity_addVel(me, 1000, 0)
	end
	
	entity_updateMovement(me, dt)
end

function enterState(me)
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	if damageType == DT_CRUSH then
		return true
	elseif damageType == DT_ENEMY_POISON or damageType == DT_ENEMY_ACTIVEPOISON then
		return true
	else
		playNoEffect()
		return false
	end
	return false
end

function hitSurface(me)
	entity_flipHorizontal(me)
	if dir == 0 then
		dir = 1
	elseif dir == 1 then 
		dir = 0
	end
end

function activate(me)
end