dofile("scripts/entities/entityinclude.lua")

n = 0
lungeDelay = 3
fireDelay = 2
shots = 3
function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "RotBaby-Form3")
	entity_setCollideRadius(me, 25)

	entity_addRandomVel(me, 500)
	
	
	entity_setUpdateCull(me, 3000)
	
	entity_setHealth(me, 6)
	
	entity_setDeathParticleEffect(me, "TinyRedExplode")
	
	entity_setMaxSpeed(me, 900)
	
	entity_setDropChance(me, 40, 1)
	
	entity_setState(me, STATE_IDLE)	
end

function postInit(me)
	n = getNaija()
end

function update(me, dt)
	entity_findTarget(me, 800)
	
	if entity_hasTarget(me) then
		if entity_isTargetInRange(me, 256) then
			entity_moveTowardsTarget(me, dt, -800)
			entity_moveAroundTarget(me, dt, 2000, 1)			
		else
			entity_moveTowardsTarget(me, dt, 1000)
		end
	end
	
	
	entity_doCollisionAvoidance(me, dt, 8, 0.5)
	entity_doEntityAvoidance(me, dt, 64, 1.0)
	
	entity_rotateToVel(me, 0.1)
	
	entity_updateMovement(me, dt)

	entity_handleShotCollisions(me)
	entity_touchAvatarDamage(me, entity_getCollideRadius(me), 1, 800)
	
	--[[
	if lungeDelay > 0 then
		lungeDelay = lungeDelay - dt
		if lungeDelay <= 0 then
			entity_setMaxSpeedLerp(me, 1.2)
			entity_setMaxSpeedLerp(me, 1, 1)
			entity_moveTowardsTarget(me, 1, 1200)
			lungeDelay = math.random(3) + 1
		end
	end
	]]--
	
	fireDelay = fireDelay - dt
	if fireDelay < 0 then
		shots = shots - 1
		if shots < 0 then
			fireDelay = math.random(2)+2
			shots = 3
		else
			fireDelay = 0.3
			s = createShot("BlasterFire", me, entity_getTarget(me))
			shot_setOut(s, 32)
			entity_moveTowardsTarget(me, 1, -500)
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	if damageType == DT_ENEMY_BEAM then
		return false
	end
	if damageType == DT_AVATAR_BITE then
		entity_changeHealth(me, -10)
	end
	return true
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

