-- rotfish-blob

dofile("scripts/entities/entityinclude.lua")

fireDelay = 1
moveTimer = 0

function init(me)
	setupBasicEntity(
	me,
	"rotfish-blob",					-- texture
	9,								-- health
	2,								-- manaballamount
	2,								-- exp
	1,								-- money
	64,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000							-- updateCull -1: disabled, default: 4000
	)

	entity_setDeathParticleEffect(me, "TinyRedExplode")
	entity_clampToSurface(me)
	
	entity_setSegs(me, 8, 8, 0.5, 0.9, 0, -0.02, 8, 1)
end

function update(me, dt)	
	entity_handleShotCollisions(me)
	entity_touchAvatarDamage(me, 48, 1, 0.1)
	
	entity_moveAlongSurface(me, dt, 40, 6, 50)
	entity_rotateToSurfaceNormal(me, 0.1)
	moveTimer = moveTimer + dt
	if moveTimer > 8 then
		entity_switchSurfaceDirection(me)
		moveTimer = 0
	end
	
	if not(entity_hasTarget(me)) then
		entity_findTarget(me, 1200)
	else
		if fireDelay > 0 then
			fireDelay = fireDelay - dt
			if fireDelay < 0 then
				entity_fireAtTarget(me, "Purple", 1, 400, 10, 3, 64)
				fireDelay = 0.5
			end
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_DEAD) then
		createEntity("Rotfish", "", entity_x(me), entity_y(me)-32)
	end
end

function exitState(me)
end

function hitSurface(me)
end
