-- ================================================================================================
-- S E A  S L U G
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")


-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================

fireDelay = 2
moveTimer = 0
shellOff = 0

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init()
	setupBasicEntity(
	"seaslug",						-- texture
	15,								-- health
	2,								-- manaballamount
	2,								-- exp
	1,								-- money
	32,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	64,								-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000							-- updateCull -1: disabled, default: 4000
	)
	
	entity_initPart(
	"Shell", 
	"seaslug-shell",
	22,
	-10,
	1,
	0, 
	0)

	
	entity_clampToSurface()
end

function update(dt)
	-- dt, pixelsPerSecond, climbHeight, outfromwall
	entity_moveAlongSurface(dt, 80, 6, 24)
	-- entity_rotateToSurfaceNormal(0.1)
	moveTimer = moveTimer + dt*80
	if moveTimer > 800 then
		entity_flipHorizontal()
		entity_switchSurfaceDirection()
		moveTimer = 0
	end
	if shellOff==0 and entity_getHealth() < 10 then
		shellOff = 1
		entity_partAlpha("Shell", 0, 1)
	end
	if not(entity_hasTarget()) then
		entity_findTarget(1200)
	else
		if entity_isTargetInRange(64) then
			entity_pushTarget(500)
			entity_hurtTarget(1)
		end
		if shellOff==1 then
			if fireDelay > 0 then
				fireDelay = fireDelay - dt
				if fireDelay < 0 then
					-- dmg, mxspd, homing, numsegs, out
					entity_fireAtTarget(1, 400, 200, 3, 64)
					fireDelay = 2
				end
			end
		end
	end
end

function enterState()
	if entity_getState()==STATE_IDLE then
	end
end

function exitState()
end

function hitSurface()
end