-- SPORE SEED

dofile("scripts/entities/entityinclude.lua")

growEmitter = 0
done = false
weight = 400

SEED_FLOWER			= 0
SEED_VINE			= 1
SEED_UBERVINE		= 2

seedType = 0

function commonInit(me, st)
	setupEntity(me)
	entity_setTexture(me, "Naija/Seedling")
	entity_setEntityLayer(me, 1)
	
	entity_initEmitter(me, growEmitter, "SporeSeedGrow")
	
	entity_setHealth(me, 1)
	entity_setCollideRadius(me, 2)
	entity_setWeight(me, weight)
	entity_setState(me, STATE_IDLE)
	entity_setMaxSpeed(me, 800)
	
	entity_alpha(me, 0)
	entity_alpha(me, 1, 0.2)
	entity_setCanLeaveWater(me, true)
	entity_setEntityType(me, ET_ENEMY)
	entity_setAllDamageTargets(me, false)
	entity_setDamageTarget(me, DT_AVATAR_BITE, true)
	
	seedType = st
	
	if seedType == SEED_FLOWER then
		entity_setTexture(me, "Naija/Seed")
	elseif seedType == SEED_UBERVINE then
		entity_setTexture(me, "Naija/Uberseed")
	end
end

function postInit(me)
	entity_ensureLimit(me, 3, STATE_DONE)
end

function terminate(me)
	if not done then
		
		if seedType == SEED_VINE then
			registerSporeDrop(entity_x(me), entity_y(me),1)
			createEntity("Vine", "", entity_getPosition(me))			
		elseif seedType == SEED_UBERVINE then
			registerSporeDrop(entity_x(me), entity_y(me),2)
			createEntity("UberVine", "", entity_getPosition(me))			
		else
			registerSporeDrop(entity_x(me), entity_y(me),0)
			createEntity("NatureFormFlowers", "", entity_getPosition(me))			
		end
		
		entity_delete(me)
		
		done = true
	end
end

function songNote(me, note)	
end

function update(me, dt)
	if not done then
		if entity_updateCurrents(me, dt) then
			entity_setWeight(me, 1)
		else
			if entity_isUnderWater(me) then
				entity_setWeight(me, weight)
			else
				entity_setWeight(me, weight*2)
			end
		end
		entity_updateMovement(me, dt)
		if entity_isNearObstruction(me, 2) then
			terminate(me)
		end
	end
end

function hitSurface(me)
	--terminate(me)
end

function enterState(me)
	if entity_isState(me, STATE_DONE) then
		debugLog("state done")
		entity_delete(me, 0.2)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	if damageType == DT_AVATAR_BITE then
		return true
	end
	return false
end

function exitState(me)
end
