-- skeletal test

dofile("scripts/entities/entityinclude.lua")


-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================


swimTime = 0.75
swimTimer = swimTime - swimTime/4
 
-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init()
	setupBasicEntity(
	"",								-- texture
	6,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	28,								-- collideRadius
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000							-- updateCull -1: disabled, default: 4000
	)

	--entity_scale(0.5, 0.5)
	entity_initSkeletal("mer", "drask")
	entity_animate("swim", -1)
end

function update(dt)
	if not entity_hasTarget() then
		entity_findTarget(1000)
	else
		if entity_hasTarget() then
			if entity_isTargetInRange(64) then
				entity_hurtTarget(1);
--				entity_moveTowardsTarget(dt, -1000)
			end
		end
		
		--[[
		swimTimer = swimTimer + dt
		if swimTimer > swimTime then			
			entity_moveTowardsTarget(1, 400)
			entity_doCollisionAvoidance(1, 6, 0.5);
			entity_doEntityAvoidance(1, 256, 0.2);
			entity_rotateToVel(0.2)
			swimTimer = swimTimer - swimTime
		else
			entity_moveTowardsTarget(dt, 100)
			entity_doEntityAvoidance(dt, 64, 0.1);
			entity_doCollisionAvoidance(dt, 6, 0.5);
		end	
		]]--
		entity_moveTowardsTarget(dt, 1000)
		entity_rotateToVel(0.1)
		entity_doCollisionAvoidance(dt, 6, 0.5)
	end
	
	--entity_doFriction(dt, 700)	
	entity_updateMovement(dt)
end

function enterState()
	if entity_getState()==STATE_IDLE then
		entity_setMaxSpeed(200)
	end
end

function exitState()
end

function hitSurface()
end