dofile("scripts/entities/entityinclude.lua")

n = 0
note = 0
node = 0

function commonInit(me, myNote)
	note = myNote
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_setTexture(me, "particles/bigglow")

	entity_setState(me, STATE_IDLE)
	
	entity_scale(me, 1, 1)
	entity_scale(me, 1.5, 1.5, 1, -1, 1, 1)
	
	entity_setBlendType(me, BLEND_ADD)
	
	entity_setColor(me, getNoteColor(note))
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
	node = getNode("WHALELAMPPUZZLEBRAIN")
end

function update(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_alpha(me, 0.01, 0.5)
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_ON) then
		entity_setStateTime(me, 12)
		entity_alpha(me, 0.5)
		entity_alpha(me, 1, 1, -1, 1, 1)
		
		if node ~= 0 then
			node_activate(node, me)
		end
	end
end

function exitState(me)
	if entity_isState(me, STATE_ON) then
		entity_setState(me, STATE_IDLE)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function lightFlare(me)
	if entity_isEntityInRange(me, n, 256) then
		entity_soundFreq(me, getNoteName(note), 0.5, 4)
		debugLog("STATE ON")
		entity_setState(me, STATE_ON)
	end
end

function activate(me)
end

