-- ================================================================================================
-- SONG STALK
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")


-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================

glow = 0
activeTimer = 0
bulb = 0

-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(
	me,
	"",								-- texture
	3,								-- health
	2,								-- manaballamount
	2,								-- exp
	10,								-- money
	16,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, 0 = none
	0,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000,							-- updateCull -1: disabled, default: 4000
	0
	)
	
	entity_setEntityType(me, ET_NEUTRAL)
	
	entity_initSkeletal(me, "SongStalk")
	glow = entity_getBoneByName(me, "Glow")
	bulb = entity_getBoneByName(me, "Bulb")	
		
	entity_setState(me, STATE_IDLE)
	
	entity_setCull(me, false)
end

function songNote(me, note)
	if entity_isState(me, STATE_IDLE) then
		entity_setState(me, STATE_ACTIVE)
	end
	activeTimer = 3.5
	transTime = 0.5
	r,g,b = getNoteColor(note)
	bone_setColor(glow, r,g,b, transTime)
end

function update(me, dt)
	if entity_isState(me, STATE_ACTIVE) then
		if activeTimer > 0 then
			activeTimer = activeTimer - dt
			if activeTimer <= 0 then
				entity_setState(me, STATE_IDLE)
			end
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then		
		entity_animate(me, "idle")
		if glow ~= 0 then
			bone_setSegs(bulb, 2, 8, 0.8, 0.1, -0.018, 0, 6, 1)
			bone_setColor(glow, 1, 1, 1, 1)
		end
	elseif entity_isState(me, STATE_ACTIVE) then
		bone_setSegs(bulb, 2, 8, 0.8, 0.1, -0.018, 0, 20, 1)
		--entity_animate(me, "wave", LOOP_INF)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function exitState(me)
end
