dofile("scripts/entities/entityinclude.lua")

n = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "SpikyBall")
	
	entity_setAllDamageTargets(me, false)
	
	entity_scale(me, 0, 0)
	entity_scale(me, 2, 2, 1)
	
	entity_color(me, 1, 0.6, 0.6)
	
	entity_setCollideRadius(me, 64)
	
	entity_setTargetRange(me, -9000)
	
	entity_setState(me, STATE_IDLE)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	entity_updateMovement(me, dt)
	
	entity_setDamageTarget(me, DT_ENEMY_ENERGYBLAST, false)
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, true)
	entity_setDamageTarget(me, DT_AVATAR_SHOCK, true)
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, true)
	
	entity_handleShotCollisions(me)
	
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, false)
	entity_setDamageTarget(me, DT_AVATAR_SHOCK, false)
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
	
	entity_touchAvatarDamage(me, entity_getCollideRadius(me), 0.5, 500, 0.2)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	playNoEffect()
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

