dofile("scripts/entities/entityinclude.lua")

n = 0
glow = 0
eyes = 0
maxRun = 1
runTimer = maxRun
moving = 0
upRate = 1


STATE_RUNAWAY = 1001

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "SpinyCrab")	
	entity_setAllDamageTargets(me, true)
	
	--entity_generateCollisionMask(me)
	entity_setCollideRadius(me, 50)
	
	glow = createQuad("Naija/LightFormGlow", 13)
	eyes = entity_getBoneByName(me, "Eyes")
	--[[
	quad_alpha(glow, 0.8)
	quad_alpha(glow, 1, 1, -1, 1, 1)
	]]--
	quad_scale(glow, 0.6, 0.3)
	--quad_scale(glow, 2, 1, 1, -1, 1, 1)
	
	entity_setState(me, STATE_IDLE)
	
	entity_setBeautyFlip(me, false)
	
	entity_clampToSurface(me)
	entity_rotateToSurfaceNormal(me, 0.1)
	entity_flipHorizontal(me)
	entity_setUpdateCull(me, 3000)
	entity_setDeathParticleEffect(me, "TinyBlueExplode")
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	dt = dt * upRate
	-- ugly slow hack
	entity_updateSkeletal(me, dt*0.5)
	entity_handleShotCollisions(me)
	--bone = entity_collideSkeletalVsCircle(me, n)
	if entity_touchAvatarDamage(me, entity_getCollideRadius(me), 0.5, 800) then
		avatar_fallOffWall()
	end
	--entity_updateMovement(me, dt)
	
	if entity_isState(me, STATE_IDLE) then
		if entity_isEntityInRange(me, n, 500) then
			runTimer = runTimer - dt
			if runTimer <= 0 then
				runTimer = maxRun
				entity_setState(me, STATE_RUNAWAY, 8)
			end
		end
	elseif entity_isState(me, STATE_RUNAWAY) then		
		entity_rotateToSurfaceNormal(me)
		entity_moveAlongSurface(me, dt, 600*moving, 6, 10)
	end
	quad_setPosition(glow, bone_getWorldPosition(eyes))
	quad_rotate(glow, bone_getWorldRotation(eyes))
end

function lightFlare(me)
	if entity_isEntityInRange(me, n, 600) then
		upRate = 1.5
		entity_setState(me, STATE_RUNAWAY, 4)
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
		if glow ~= 0 then
			quad_alpha(glow, 1, 0.5)
		end
		if eyes ~= 0 then
			quad_alpha(eyes, 1, 0.5)
		end
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_RUNAWAY) then
		if upRate == 1.0 then
			entity_switchSurfaceDirection(me)
			entity_flipHorizontal(me)
			entity_clampToSurface(me)
		end
		
		quad_alpha(glow, 0, 3)
		quad_alpha(eyes, 0, 3)
		entity_animate(me, "runAway", -1)
	end
end

function exitState(me)
	if entity_isState(me, STATE_RUNAWAY) then
		upRate = 1
		entity_setState(me, STATE_IDLE)
	end
end

function damage(me, attacker, bone, damageType, dmg)
	if damageType == DT_ENEMY_TRAP or damageType == DT_AVATAR_VINE then
		return true
	end
	return false
end

function animationKey(me, key)
	if entity_isState(me, STATE_RUNAWAY) and ((key > 2 and key < 5) or (key == 1)) then
		moving = 1
	else
		moving = 0.6
	end
	if entity_isState(me, STATE_RUNAWAY) and (key == 3) then
		entity_sound(me, "Scuttle", math.random(200)+900)
	end
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

function dieNormal(me)
	if chance(60) then
		spawnIngredient("SpiderEgg", entity_x(me), entity_y(me))
	end
end



