dofile("scripts/entities/entityinclude.lua")

n = 0
hits = 0

function init(me)
	setupEntity(me)
	entity_setEntityLayer(me, -2)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "SunkenDoor")

--[[	
	entity_setAllDamageTargets(me, false)
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, true)
]]--
	
	entity_generateCollisionMask(me)	
	
	entity_setState(me, STATE_IDLE)
	
	entity_scale(me, 1.5, 1.5)
	entity_setCullRadius(me, 1024)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	entity_handleShotCollisionsSkeletal(me)
	bone = entity_collideSkeletalVsCircle(me, n)
	if bone ~= 0 then
		entity_clearVel(n)
		entity_addVel(n, 500, 0)
		entity_setPosition(n, entity_x(n)+2, entity_y(n))
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_OPEN) then
		entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
		entity_animate(me, "open")
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	if entity_isState(me, STATE_IDLE) then
	--[[
		if damageType == DT_AVATAR_LIZAP then
			hits = hits + dmg
			if hits > 5 then
				entity_setState(me, STATE_OPEN)
			end
		end
	]]--
	end
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

