-- ================================================================================================
-- TEMPLE STATUE
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")

-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================


-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

bone_head = 0

function init(me)
	setupBasicEntity(
	me,
	"",								-- texture
	15,								-- health
	2,								-- manaballamount
	2,								-- exp
	1,								-- money
	32,								-- collideRadius (for hitting entities + spells)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)
	4000,							-- updateCull -1: disabled, default: 4000
	0
	)
	entity_setCull(me, false)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_initSkeletal(me, "TempleStatue")
	
	bone_head = entity_getBoneByName(me, "Head")
	
	entity_setName(me, "TempleStatue")
	entity_setState(me, STATE_IDLE)
end

function update(me, dt)
	if entity_isState(me, STATE_IDLE) or entity_isState(me, STATE_BREAK) then
		entity_setLookAtPoint(me, bone_getWorldPosition(bone_head))
	end
end

function enterState(me)
	if entity_getState(me)==STATE_IDLE then
		entity_animate(me, "idle", LOOP_INF)		
	elseif entity_isState(me, STATE_BREAK) then			
		entity_setStateTime(me, entity_animate(me, "break"))
	elseif entity_isState(me, STATE_BROKEN) then
		esetv(me, EV_LOOKAT, 0)
		entity_animate(me, "broken", LOOP_INF)
	end
end

function animationKey(me, key)
end

function exitState(me)
	if entity_isState(me, STATE_BREAK) then
		esetv(me, EV_LOOKAT, 0)
		--entity_setState(me, STATE_BROKEN)
	end
end

function hitSurface(me)
end
