dofile("scripts/entities/entityinclude.lua")

n = 0
targetBone = 0
ventBone = 0


STATE_OPT		= 1001

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "ThermalVent")	
	entity_setEntityLayer(me, -2)
	entity_setAllDamageTargets(me, false)
	
	entity_generateCollisionMask(me)
		
	targetBone = entity_getBoneByName(me, "Target")
	ventBone = entity_getBoneByName(me, "Vent")
	
	bone_alpha(targetBone)
	bone_alpha(ventBone)
	entity_setState(me, STATE_IDLE)
	entity_setUpdateCull(me, 1100)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
	--[[
	entity_handleShotCollisionsSkeletal(me)	
	]]--
	e = getFirstEntity()
	while e ~= 0 do
		if e ~= me and eisv(e, EV_CRAWLING, 0) and entity_getName(e) ~= "thermalvent" then
			x, y = bone_getWorldPosition(targetBone)
			x2, y2 = bone_getWorldPosition(ventBone)
			if entity_collideCircleVsLine(e, x, y, x2, y2, 64) then
				entity_addVel(e, 0, -2000*dt)
			end
			
			if entity_collideCircleVsLine(e, x, y, x2, y2, 16) then
				y = entity_vely(e)
				entity_clearVel(e)
				if entity_x(n) < entity_x(me) then
					entity_addVel(e, -100, y)
				else
					entity_addVel(e, 100, y)
				end
			end
		end
		e = getNextEntity()
	end

	bone = entity_collideSkeletalVsCircle(me, n)
	if bone ~= 0 then
		entity_touchAvatarDamage(me, 0, 0, 400, 0)
	end
	--[[
	if entity_isEntityInRange(me, n, 1000) then
		entity_setState(me, STATE_IDLE)
		entity_animate(me, "idle", -1)
	else
		entity_animate(me, "opt", -1)
	end	
	]]--
	entity_updateMovement(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1)
	elseif entity_isState(me, STATE_OPT) then
		entity_animate(me, "opt", -1)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

