-- SPORE SEED

dofile("scripts/entities/entityinclude.lua")

growEmitter = 0
done = false
lifeTime = 0
n = 0
limited = false

function commonInit(me, lim)
	setupEntity(me)
	entity_initSkeletal(me, "UberVine")
	entity_setEntityLayer(me, -1)
	
	entity_setCollideRadius(me, 0)
	entity_setState(me, STATE_IDLE)
	--entity_setInternalOffset(me, 0, -256)
	entity_setInternalOffset(me, 0, -200)
	
	entity_setDamageTarget(me, DT_AVATAR_VINE, false)
	
	lifeTime = 15
	
	entity_alpha(me, 0)
	entity_alpha(me, 1, 0.3)
	
	entity_scale(me, 1, 0)
	entity_scale(me, 1, 1, 0.2)
	
	--[[
	entity_scale(me, 1, 0.9)
	entity_scale(me, 1, 1, 0.5, 0, 0, 1)
	]]--
	
	entity_clampToSurface(me)
	entity_animate(me, "idle", 0, 0, 0)
	
	entity_setCullRadius(me, 1024)
	
	entity_generateCollisionMask(me)
	entity_setHealth(me, 8)
	
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
	entity_setDamageTarget(me, DT_AVATAR_BITE, false)
	entity_setDamageTarget(me, DT_AVATAR_PETBITE, false)
	
	entity_sound(me, "UberVineGrow")
	
	limited = lim
end

function postInit(me)
	n = getNaija()
	entity_clampToSurface(me)
	entity_rotateToSurfaceNormal(me)
	
	if limited then
		entity_ensureLimit(me, 3, STATE_DONE)
	end
end

function songNote(me, note)
end

function shotHitEntity(me, ent, shot)
	--debugLog("shot hit entity!")
	sx, sy = entity_getScale(me)
	sx2, sy2 = bone_getScale(entity_getBoneByIdx(me, 0))
	len = 400*sy*sy2
	x1,y1 = entity_getPosition(me)
	fx, fy = entity_getNormal(me)
	x2 = x1 + fx*len
	y2 = y1 + fy*len
	
	doFall = false
	if entity_getEntityType(ent) ~= ET_NEUTRAL and ent ~= me and entity_isDamageTarget(ent, DT_AVATAR_VINE) and eisv(ent, EV_VINEPUSH, 1) then
		doIt = true
		dmg = 1
		if entity_getEntityType(ent) == ET_AVATAR then
			if isForm(FORM_NATURE) then
				dmg = 0
				if avatar_isLockable() then
					return
				end
			end
			doFall = true
		end
		if doIt then
			--[[
			if entity_collideCircleVsLine(ent, x1,y1,x2,y2,32) then	
				if doFall then
					avatar_fallOffWall()
				end
				
				cx, cy = getLastCollidePosition()
				dx = entity_x(ent) - cx
				dy = entity_y(ent) - cy
				if dx ~= 0 or dy ~= 0 then
					dx, dy = vector_setLength(dx, dy, 500)
					--entity_push(ent, dx, dy, 0.1)
					entity_addVel(ent, dx, dy)
				end
			end
			]]--
			dx = 0
			dy = 0
			if entity_isAnimating(me) then
				dx = entity_x(ent) - entity_x(me)
				dy = entity_y(ent) - entity_y(me)
				
				if doFall then
					avatar_fallOffWall()
				end
			else
				cx, cy = shot_getPosition(shot)
				dx = entity_x(ent) - cx
				dy = entity_y(ent) - cy
			end
			
			if dx ~= 0 or dy ~= 0 then
				--debugLog("push!")
				dx, dy = vector_setLength(dx, dy, 2000)
				entity_addVel(ent, dx, dy)
				--entity_warpLastPosition(ent)
				--entity_push(ent, dx, dy, 5000, 1)
			end
		end
	end
end

spawnDelay = 0

function spawnShots(me)
	if spawnDelay == 0 then
		sx, sy = entity_getScale(me)
		sx2, sy2 = bone_getScale(entity_getBoneByIdx(me, 0))
		len = 400*sy*sy2
		x1,y1 = entity_getPosition(me)
		fx, fy = entity_getNormal(me)
		x2 = x1 + fx*len
		y2 = y1 + fy*len
		
		bit = len/4
		totlen = 0
		while totlen < len do
			px = x1 + fx*totlen
			py = y1 + fy*totlen
			
			s = createShot("Vine", me, 0, px, py)
			
			totlen = totlen + bit
		end
		
		spawnDelay = 0.5
	end
end

function update(me, dt)
	if not entity_isAnimating(me) and limited and isFlag(FLAG_NAIJA_FIRSTVINE, 0) and entity_isEntityInRange(me, n, 600) then
		emote(EMOTE_NAIJALAUGH)
		setFlag(FLAG_NAIJA_FIRSTVINE, 1)
	end
	if spawnDelay > 0 then
		spawnDelay = spawnDelay - dt
		if spawnDelay < 0 then
			spawnDelay = 0
		end
	end
	if done and not entity_isAnimating(me) then
		entity_scale(me, 1, 0, 0.2)
		entity_delete(me, 0.2)
		
	end
	if not done then
		entity_handleShotCollisionsSkeletal(me)
		lifeTime = lifeTime - dt
		if lifeTime < 0 then
			--entity_delete(me, 0.2)
			entity_animate(me, "shrink")
			done = true
			entity_sound(me, "UberVineShrink")
		end
		
		spawnShots(me)
		
		--if isForm(FORM_NATURE) then
		bone = entity_collideSkeletalVsCircle(me, n)
		
		--[[
		if bone ~= 0 then
			debugLog(string.format("collided with bone named [%s] idx[%d]", bone_getName(bone), bone_getIndex(bone)))
		end
		]]--
		if isForm(FORM_NATURE) and avatar_isLockable() and bone ~=0 and bone_getIndex(bone) == 0 and entity_setBoneLock(n, me, bone) then
		else
			---entity_touchAvatarDamage(me, entity_getCollideRadius(me), 0, 1000)
			if bone ~= 0 then
				if entity_isAnimating(me) then
					entity_moveTowards(n, entity_x(me), entity_y(me), 1, -1000)
					avatar_fallOffWall()
				else
					bx, by = bone_getWorldPosition(bone)
					entity_moveTowards(n, bx, by, 1, -1000)
					
					if not isForm(FORM_NATURE) then
						entity_damage(n, me, 0.25, DT_AVATAR_VINE)
					end
				end
				--entity_doCollisionAvoidance(n, 1, 5, 1)
			--[[
				cx, cy = getLastCollidePosition()
				dx = entity_x(n) - cx
				dy = entity_y(n) - cy
				if dx ~= 0 or dy ~= 0 then
					dx, dy = vector_setLength(dx, dy, 500)
					--entity_push(ent, dx, dy, 0.1)
					entity_addVel(n, dx, dy)
				end
				]]--
			end
		end

		--[[
		if true then
			sx, sy = entity_getScale(me)
			sx2, sy2 = bone_getScale(entity_getBoneByIdx(me, 0))
			len = 400*sy*sy2
			x1,y1 = entity_getPosition(me)
			fx, fy = entity_getNormal(me)
			x2 = x1 + fx*len
			y2 = y1 + fy*len
			
			doFall = false
			ent = getFirstEntity()
			while ent~=0 do
				if entity_getEntityType(ent) ~= ET_NEUTRAL and ent ~= me and entity_isDamageTarget(ent, DT_AVATAR_VINE) then
					doIt = true
					dmg = 1
					if entity_getEntityType(ent) == ET_AVATAR then
						if isForm(FORM_NATURE) then
							dmg = 0
							if avatar_isBursting() then
								doIt = false
							end
						end
						doFall = true
					end
					if doIt then
						if entity_collideCircleVsLine(ent, x1,y1,x2,y2,32) then	
							if doFall then
								avatar_fallOffWall()
							end
							if dmg ~= 0 then
								entity_damage(ent, me, dmg, DT_AVATAR_VINE)
							end
							
							cx, cy = getLastCollidePosition()
							dx = entity_x(ent) - cx
							dy = entity_y(ent) - cy
							if dx ~= 0 or dy ~= 0 then
								dx, dy = vector_setLength(dx, dy, 500)
								--entity_push(ent, dx, dy, 0.1)
								entity_addVel(ent, dx, dy)
							end
						end
					end
				end
				
				ent = getNextEntity()
			end
		end
		]]--
		--[[
		if not entity_isNearObstruction(me, 3) then		
			done = true
		end
		]]--
	end
end

function hitSurface(me)
end

function enterState(me)
	if entity_isState(me, STATE_DONE) then
		debugLog("VINE DONE")
		done = true
		entity_scale(me, 1, 0, 0.2)
		entity_delete(me, 0.2)
		entity_sound(me, "UberVineShrink")
	end
end

function damage(me, attacker, bone, damageType, dmg)
	return true
end

function exitState(me)
end
