dofile("scripts/entities/entityinclude.lua")

n = 0
cantPickupTimer = 3

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_NEUTRAL)
	entity_setTexture(me, "gui/wok")
	
	entity_initEmitter(me, 0, "upgrade-wok-glow")
	entity_startEmitter(me, 0)
	
	entity_setState(me, STATE_IDLE)
	
	entity_setWeight(me, 200)
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
	
	if not isFlag(FLAG_UPGRADE_WOK, 0) then
		entity_delete(me)
	end
end

function update(me, dt)
	entity_updateMovement(me, dt)
	
	if cantPickupTimer > 0 then
		cantPickupTimer = cantPickupTimer - dt
		if cantPickupTimer < 0 then
			cantPickupTimer = 0
		end
	else
		if isFlag(FLAG_UPGRADE_WOK, 0) then
			if entity_isEntityInRange(me, getNaija(), 64) then
				setFlag(FLAG_UPGRADE_WOK, 1)
				playSfx("memory-found")
				spawnParticleEffect("Collect", entity_x(me), entity_y(me))
				entity_stopEmitter(me, 0)
				entity_alpha(me, 0, 0.5)
				
				setControlHint(getStringBank(26), 0, 0, 0, 8, "gui/icon-food")
			end
		end
	end
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

