-- SPORE SEED

dofile("scripts/entities/entityinclude.lua")

growEmitter = 0
done = false
lifeTime = 0

function init(me)
	setupEntity(me)
	entity_setTexture(me, "Naija/Thorn")
	--[[
	entity_setWidth(me, 64)
	entity_setHeight(me, 512)
	]]--
	entity_setEntityLayer(me, -1)
	
	entity_initEmitter(me, growEmitter, "SporeSeedGrow")
	
	entity_setCollideRadius(me, 0)
	entity_setState(me, STATE_IDLE)
	entity_setInternalOffset(me, 0, -128)
	
	lifeTime = 5
	
	entity_alpha(me, 0)
	entity_alpha(me, 1, 0.1)
	
	entity_scale(me, 1, 0)
	entity_scale(me, 1, 1, 0.5, 0, 0, 1)
	
	entity_clampToSurface(me)
end

function postInit(me)
	entity_rotateToSurfaceNormal(me)
end

function songNote(me, note)
end

function update(me, dt)
	if not done then
		lifeTime = lifeTime - dt
		if lifeTime < 0 then
			entity_delete(me, 0.2)
			done = true
		end

		sx, sy = entity_getScale(me)
		len = 256*sy
		x1,y1 = entity_getPosition(me)
		fx, fy = entity_getNormal(me)
		x2 = x1 + fx*len
		y2 = y1 + fy*len
			
		iter = 0
		ent = getFirstEntity()
		while ent~=0 do
			if entity_getEntityType(ent) ~= ET_NEUTRAL and ent ~= me and entity_isDamageTarget(ent, DT_AVATAR_VINE) then
				dmg = 0.5
				if entity_getEntityType(ent)==ET_AVATAR and isForm(FORM_NATURE) then
					dmg = 0
				end
				if entity_collideCircleVsLine(ent, x1,y1,x2,y2,16) then
					if dmg ~= 0 then
						entity_damage(ent, me, 0.5, DT_AVATAR_VINE)
					end
				end
			end
					
			ent = getNextEntity()
		end
		
	end
end

function hitSurface(me)
end

function enterState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function exitState(me)
end
