dofile("scripts/entities/entityinclude.lua")

ANIMLAYER_LI = 0
ANIMLAYER_BOAT = 1
n = 0

headNormal = 0
headShock = 0

function init(me)
	setupEntity(me)
	entity_setEntityType(me, ET_ENEMY)
	entity_initSkeletal(me, "YoungLi")	
	entity_setAllDamageTargets(me, false)
	
	entity_setCull(me, false)
	entity_setState(me, STATE_IDLE)
	
	headNormal = entity_getBoneByName(me, "Head")
	headShock = entity_getBoneByName(me, "HeadShock")
end

function postInit(me)
	n = getNaija()
	entity_setTarget(me, n)
end

function update(me, dt)
end

function enterState(me)
	if entity_isState(me, STATE_IDLE) then
		entity_animate(me, "idle", -1, ANIMLAYER_BOAT)
		entity_animate(me, "cruise", -1, ANIMLAYER_LI)
	elseif entity_isState(me, STATE_ON) then
		entity_animate(me, "idle", -1, ANIMLAYER_LI)
	elseif entity_isState(me, STATE_OFF) then
		bone_setVisible(headNormal, 0)
		bone_setVisible(headShock, 1)
	elseif entity_isState(me, STATE_ATTACK) then
		bone_setVisible(headNormal, 1)
		bone_setVisible(headShock, 0)
		entity_animate(me, "puzzled", 0, ANIMLAYER_LI)
	end
end

function exitState(me)
end

function damage(me, attacker, bone, damageType, dmg)
	return false
end

function animationKey(me, key)
end

function hitSurface(me)
end

function songNote(me, note)
end

function songNoteDone(me, note)
end

function song(me, song)
end

function activate(me)
end

