-- ================================================================================================
-- M O N E Y E
-- ================================================================================================

dofile("scripts/entities/entityinclude.lua")


-- ================================================================================================
-- L O C A L  V A R I A B L E S 
-- ================================================================================================


orient = ORIENT_LEFT
orientTimer = 0

swimTime = 0.75
swimTimer = swimTime - swimTime/4

cover = 0
head = 0
 
-- ================================================================================================
-- FUNCTIONS
-- ================================================================================================

function init(me)
	setupBasicEntity(me, 
	"",					-- texture
	2,								-- health
	1,								-- manaballamount
	1,								-- exp
	1,								-- money
	28,								-- collideRadius (only used if hit entities is on)
	STATE_IDLE,						-- initState
	128,							-- sprite width	
	128,							-- sprite height
	1,								-- particle "explosion" type, maps to particleEffects.txt -1 = none
	1,								-- 0/1 hit other entities off/on (uses collideRadius)	
	4000,							-- updateCull -1: disabled, default: 4000
	1
	)
	
	entity_initSkeletal(me, "Zygote")

	entity_scale(me, 0.5, 0.5)
	
	entity_setDeathParticleEffect(me, "TinyRedExplode")

	entity_setEatType(me, EAT_FILE, "ZygoteShot")	
	
	cover = entity_getBoneByName(me, "Cover")
	head = entity_getBoneByName(me, "Head")
	bone_setSegs(cover, 2, 16, 0.6, 0.6, -0.028, 0, 6, 1)
	bone_setSegs(head, 2, 16, 0.8, 0.8, -0.05, 0, 6, 1)
	
	entity_setMaxSpeedLerp(me, 2)
	entity_addVel(me, 0, -1000)
	
	entity_setMaxSpeedLerp(me, 1, 1)
	
	swimTimer = -1
	
	
	--[[
	entity_setDamageTarget(me, DT_AVATAR_ENERGYBLAST, false)
	entity_setDamageTarget(me, DT_AVATAR_LIZAP, false)
	entity_setDamageTarget(me, DT_AVATAR_PET, false)
	]]--
	
	entity_setAllDamageTargets(me, false)
	
	entity_setDamageTarget(me, DT_AVATAR_BITE, true)
	
	--entity_setMaxSpeed(me, 1000)
end

function update(me, dt)
	amt = 400
	
	entity_touchAvatarDamage(me, 16, 1, 1200)
	
	entity_handleShotCollisions(me)
	if not entity_hasTarget(me) then
		entity_findTarget(me, 500)
		swimTimer = swimTimer + dt
		if swimTimer > swimTime then	
			swimTimer = swimTimer - swimTime
			if orient == ORIENT_LEFT then
				entity_addVel(me, -amt, 0)
				orient = ORIENT_UP
			elseif orient == ORIENT_UP then
				entity_addVel(me, 0, -amt)
				orient = ORIENT_RIGHT
			elseif orient == ORIENT_RIGHT then
				entity_addVel(me, amt, 0)
				orient = ORIENT_DOWN
			elseif orient == ORIENT_DOWN then
				entity_addVel(me, 0, amt)
				orient = ORIENT_LEFT
			end			
			entity_rotateToVel(me, 0.2)
			orientTimer = orientTimer + dt
			entity_doEntityAvoidance(me, 1, 256, 0.2)
		end
		entity_doCollisionAvoidance(me, dt, 6, 0.5)
	else
		
		swimTimer = swimTimer + dt
		if swimTimer > swimTime then			
			entity_moveTowardsTarget(me, 1, amt)
			if not entity_isNearObstruction(getNaija(), 8) then
				entity_doCollisionAvoidance(me, 1, 6, 0.5)
			end
			entity_doEntityAvoidance(me, 1, 256, 0.2)
			entity_rotateToVel(me, 0.2)
			swimTimer = swimTimer - swimTime
		else
			entity_moveTowardsTarget(me, dt, 100)
			entity_doEntityAvoidance(me, dt, 64, 0.1)
			--if not entity_isNearObstruction(getNaija(), 8) then
			entity_doCollisionAvoidance(me, dt, 6, 0.5)
			--end
		end
		entity_findTarget(me, 800)
	end
	entity_doFriction(me, dt, 600)	
	entity_updateCurrents(me, dt)
	entity_updateMovement(me, dt)
end

function enterState(me)
	if entity_getState(me)==STATE_IDLE then
		entity_setMaxSpeed(me, 400)
	end
end

function exitState(me)
end

function hitSurface(me)
	orient = orient + 1
end