dofile("scripts/entities/entityinclude.lua")

doScene = true
debugEnd = false

function init()
	fade2(0, 1, 1, 1, 1)
	
	loadSound("mother")
	loadSound("proploop")
	loadSound("airship-engineloop")
	loadSound("airship-boost")
	loadSound("airship-onboard")
	
	if doScene then
	
		ship = getEntityByName("airship")
		
		start = getNode("naijastart")
		l1 = getNode("l1")
		lu = getEntity("lucien")
		entity_setPosition(getNaija(), node_x(start), node_y(start))
		
		camDummy = createEntity("Empty")
		
		overrideZoom(1.2)
		
		entity_animate(lu, "crystal", -1)
		
		cam_toNode(l1)
		watch(1)
		
		entity_animate(lu, "crystal", -1)
	
		playMusicOnce("lucien")
		
		watch(4)
		
		overrideZoom(0.9, 10)
		
		fade(0, 3)
		watch(3)
		
		spawnParticleEffect("spiritbeacon", node_x(l1), node_y(l1))
		
		playSfx("spirit-beacon")
		watch(0.5)
		entity_animate(lu, "idle", -1)
		playSfx("spirit-return")
		watch(0.5)
		playSfx("mother")
		--centerText("...mother...")
		
		watch(2)
		fade(1, 3)
		watch(3)
		
		--centerText("")
		
		cam_toNode(getNode("ship"))
		watch(2)
		overrideZoom(0.9)
		overrideZoom(0.6, 10)
		
		sfx = playSfx("proploop", 0, 0.1)
		
		fade(0, 3)
		watch(3)
		watch(3)
		fade(1, 3)
		watch(3)
		fadeSfx(sfx, 3)
		
		
		cam_toNode(getNode("l2"))
		watch(1)
		
		overrideZoom(1.0, 10)
		
		fade(0, 3)
		watch(3)
		watch(3)
		fade(1, 3)
		watch(3)
		
		watch(4)
		
		cam_toEntity(ship)
		-- get out of water
		watch(2)
		playSfx("splash-outof")
		watch(1)
		
		playSfx("airship-onboard")
		watch(2.2)
		
		engineLoop = playSfx("airship-engineloop", 0, 0.4)
		
		
		entity_fh(lu)
		entity_animate(lu, "fly", -1)
		
		entity_msg(ship, "attach", lu)
		
		watch(1)
		
		playMusicOnce("flyaway")
		
		overrideZoom(0.55)
		
		overrideZoom(0.3, 30)
		
		flyNode = getNode("fly")
		entity_setPosition(ship, node_x(flyNode), node_y(flyNode), 30, 0, 0, 1) 
		
		sfx = playSfx("proploop", 0, 0.2)
		
		playSfx("airship-boost")
		
		node = getNode("airshipboost")
		spawnParticleEffect("tinyredexplode", node_x(node), node_y(node))
		
		fade(0, 3)
		watch(3)
		
		watch(6)
		
		fadeSfx(sfx, 20)
		fadeSfx(engineLoop, 20)
		watch(4)
		
		centerText("To Be Continued...")
		
		watch(4)
		

		fade(1, 4)
		watch(4)
		
		fade2(1, 1, 0, 0, 0)
		
		watch(4)
		
		if debugEnd then
			fade(0, 1)
			cam_toEntity(getNaija())
		else
			setFlag(FLAG_SKIPSECRETCHECK, 1)
			loadMap("thirteenlair")
		end
	end
end

