dofile("scripts/entities/entityinclude.lua")

n = 0
mia = 0
done = false
head = 0

function init(me)
	n = getNaija()
	
	-- get start conditions
	
	mia = createEntity("13_Progression", "", node_x(me), node_y(me))
	entity_alpha(mia)
	
	loadSound("mia-appear")
end

function update(me, dt)
	if not done then 
		if node_isEntityIn(me, n) then
			--debugLog(string.format("mithala flag: %d", getFlag(FLAG_BOSS_MITHALA)))
			if isFlag(FLAG_BOSS_MITHALA, 1) then
				setFlag(FLAG_BOSS_MITHALA, 2)
			elseif isFlag(FLAG_BOSS_FOREST, 1) then
				setFlag(FLAG_BOSS_FOREST, 2)
			-- no suitable place for this to happen right now
			--[[
			elseif isFlag(FLAG_BOSS_SUNWORM, 1) then
				setFlag(FLAG_BOSS_SUNWORM, 2)
			]]--
			else
				return
			end
			
			offx = 80
			offy = -20
			if entity_x(n) < node_x(me) then
				offx = -offx
			end
			
			entity_setPosition(n, node_x(me)+offx, node_y(me)+offy, 1, 0, 0, 1)
		
			debugLog("running script")
			done = true
			
			entity_idle(n)
			entity_setPosition(mia, node_x(me), node_y(me))
			entity_flipToEntity(mia, n)
			entity_flipToEntity(n, mia)
			
			cam_toEntity(mia)
			
			playSfx("mia-appear")
			
			spawnParticleEffect("MiaWarp", node_x(me), node_y(me))
			
			fadeOutMusic(2)
			setSceneColor(0.5, 0.5, 1, 2)
			watch(2)
			
			playMusic("Mystery")
			
			entity_alpha(mia, 1, 2)
			
			watch(2)
			watch(4)
			
			if isFlag(FLAG_13PROGRESSION, 0) then
			end
			incrFlag(FLAG_13PROGRESSION, 1)
			
			playSfx("mia-appear")
			spawnParticleEffect("MiaWarp", node_x(me), node_y(me))
			watch(1)
			fadeOutMusic(3)
			setSceneColor(1, 1, 1, 3)
			entity_alpha(mia, 0, 1)
			watch(2)
			entity_setPosition(mia, 0, 0)
			
			cam_toEntity(n)
			
			updateMusic()
		
		end
	end
	
end
