dofile("scripts/entities/entityinclude.lua")

linode = 0
function init(me)
	door = node_getNearestEntity(me, "sunkendoor")
	
	if hasLi() then
		node_setCursorActivation(me, true)
	end
	
	loadSound("sunkendoor-unlock")
	loadSound("sunkendoor-open")
	
	linode = getNode("liopendoor")
end

function update(me, dt)
	if doflip then
		li = getLi()
		if entity_isfh(li) then entity_fh(li) end
		--bone_setAnimated(entity_getBoneByName(li, "head"), ANIM_ALL)
	end
end

function activate(me)
	li = getLi()
	n = getNaija()
	
	doflip = true
	
	fadet = 0.5
	
	wrench = entity_getBoneByName(li, "wrench")
	
	entity_setState(li, STATE_OPEN)
	
	
	
	if entity_isfh(n) then entity_fh(n) end
	
	overrideZoom(1.2, 1)
	
	fade2(1, fadet) watch(fadet)
	
	
	entity_setPosition(li, node_x(linode), node_y(linode))
	
	cam_toEntity(li)
	
	entity_setPosition(n, node_x(linode)+64, node_y(linode)-15)
	bone_setVisible(wrench, 1)
	entity_animate(li, "work", 0, 4)
	
	if entity_isfh(li) then entity_fh(li) end
	
	fade2(0, fadet) watch(fadet)
	
	watch(3)
	
	--- click
	playSfx("sunkendoor-unlock")
	
	entity_msg(li, "expression", 5)
	
	watch(0.8)
	
	entity_msg(li, "expression", 2)
	
	playSfx("sunkendoor-open")
	entity_setState(door, STATE_OPEN)
	
	overrideZoom(0.7, 4)
	
	watch(1.8)
	entity_animate(li, "idle", -1)
	bone_scale(wrench, 0, 0, 1)
	
	voiceOnce("Naija_SunkenCityOpened")
	
	entity_setState(li, STATE_IDLE)
	cam_toEntity(n)
	
	node_setCursorActivation(me, false)
	doflip = false
	
	overrideZoom(0)
end

