dofile("scripts/entities/entityinclude.lua")

spawned = false
dad = 0
mom = 0
door = 0
didInit = false

function init(me)
	door = node_getNearestEntity(me, "EnergyDoor")
	dad = getEntityByName("SunkenDad")
	mom = getEntityByName("SunkenMom")	
	if isFlag(FLAG_SUNKENCITY_BOSS, 1) then
		entity_delete(dad)
		entity_delete(mom)
		return
	end
end

function doInit(me)
	--debugLog("Setting door to opened")
	entity_setState(door, STATE_OPENED)
end

function update(me, dt)
	if not didInit then
		doInit(me)
		didInit = true
	end
	if isFlag(FLAG_SUNKENCITY_BOSS, 1) then
		return
	end
	if entity_isState(dad, STATE_DEATHSCENE) then
		setFlag(FLAG_SUNKENCITY_BOSS, 1)
		entity_setState(door, STATE_OPEN)
	end	
	if not spawned then
		if node_isEntityIn(me, getNaija()) then
			entity_setState(dad, STATE_START)
			entity_setState(mom, STATE_START)
			entity_setState(door, STATE_CLOSE)
			spawned = true			
		end
	end
end
