dofile("scripts/entities/entityinclude.lua")

function init(me)
	node_setCursorActivation(me, true)
	node_setCatchActions(me, true)
end

function action(me, action, state)
	if isNestedMain() then return end
	if getNodeToActivate() == me and state == 1 then
		if action == ACTION_MENURIGHT then
			node = getNode("TITLE_CONTINUE")
			setNodeToActivate(node)
			setMousePos(toWindowFromWorld(node_x(node), node_y(node)-20))
		elseif action == ACTION_MENULEFT or action == ACTION_MENUUP then
			node = getNode("TITLE_MODS")
			setNodeToActivate(node)
			setMousePos(toWindowFromWorld(node_x(node), node_y(node)-20))
		end
		return false
	end
	if getNodeToActivate() == 0 and state == 1 then
		if action == ACTION_MENURIGHT or action == ACTION_MENULEFT or action == ACTION_MENUUP or action == ACTION_MENUDOWN then
			setNodeToActivate(me)
			setMousePos(toWindowFromWorld(node_x(me), node_y(me)-20))	
		end
		return false
	end
	return true
end

function activate(me)
	if isNestedMain() then return end
	
	playSfx("TitleAction")
	spawnParticleEffect("TitleEffect1", node_x(me), node_y(me))
	watch(0.5)
	
	setNodeToActivate(0)
	stopCursorGlow()
	
	toggleCursor(false)
	fade(1, 2, 0, 0, 0)
	watch(2)
	fadeOutMusic(3)
	jumpState("Intro2")
end

function update(me, dt)
end
