dofile("scripts/entities/entityinclude.lua")

function init(me)
	node_setCursorActivation(me, true)
	node_setCatchActions(me, true)
end

function action(me, action, state)
	if isNestedMain() then return end
	if getNodeToActivate() == me and state == 1 then
		if action == ACTION_MENULEFT then
			debugLog("L!")
			node = getNode("TITLE_CONTINUE")
			setNodeToActivate(node)
			setMousePos(toWindowFromWorld(node_x(node), node_y(node)-20))
			return false
		end
	end
	return true
end

function activate(me)
	if isNestedMain() then return end

	playSfx("TitleAction")
	spawnParticleEffect("TitleEffect1", node_x(me), node_y(me))
	watch(0.5)
	
	doQuit = false
	
	if confirm("", "exit") then
		doQuit = true
	end

	setNodeToActivate(0)
	stopCursorGlow()
	
	if doQuit then
		fadeOutMusic(2)
		toggleVersionLabel(false)
		toggleCursor(false)
		fade(1, 3, 0, 0, 0)
		watch(3)
		watch(0.5)
		quit()
	end
end

function update(me, dt)
end
