<?php
/**
 * Página principal - Lista de categorías
 * Permite navegar por las categorías para agregar detalles de productos
 */

require_once __DIR__ . '/Database.php';

$db = new Database('../db.sqlite3');
$categories = $db->getAllCategories();

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Todoyeso - Gestión de Productos</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🏛️ Todoyeso - Gestión de Productos</h1>
            <p>Selecciona una categoría para agregar detalles de productos</p>
        </div>

        <?php if (empty($categories)): ?>
            <div class="empty-state">
                <p>No hay categorías disponibles</p>
            </div>
        <?php else: ?>
            <div class="categories-grid">
                <?php foreach ($categories as $category): ?>
                    <div class="category-card">
                        <h2><?php echo htmlspecialchars($category['name']); ?></h2>
                        <p><?php echo htmlspecialchars($category['dir_name']); ?></p>
                        <div class="category-info">
                            <?php if ($category['hay_fotos']): ?>
                                <span class="badge badge-fotos">📷 Fotos</span>
                            <?php endif; ?>
                            <?php if ($category['hay_tamanos']): ?>
                                <span class="badge badge-tamanos">📏 Tamaños</span>
                            <?php endif; ?>
                        </div>
                        <a href="form.php?category_id=<?php echo $category['id']; ?>&category_name=<?php echo urlencode($category['name']); ?>" class="btn">
                            Agregar Detalles de Productos
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>

